package editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ColorCanvas extends JPanel {

	private Color currentPreviewColor;
	private Image nothingImage;
	
	public ColorCanvas() {
		
		super();
		
		Border border = BorderFactory.createLineBorder(new Color(0,0,0));
		
		this.setBorder(border);
		
		this.setPreferredSize(new Dimension(200, 200));
		this.setMinimumSize(new Dimension(200, 200));
		this.setMaximumSize(new Dimension(200, 200));
		
		ImageIcon tempIcon = new ImageIcon(ColorCanvas.class.getResource("/images/no_color.GIF"));
		
		if(tempIcon != null) {
			nothingImage = tempIcon.getImage();
//		} else {
//			System.out.println("Agh!  The image is null!");
		}
		
		refresh();
		
	}
	
	public void paintComponent(Graphics g) {
		
		super.paintComponent(g);
		
		if(currentPreviewColor != null) {
			Color origColor = g.getColor();
			g.setColor(currentPreviewColor);
			g.fillRect(10, 20, 130, 110);
			g.setColor(origColor);
		} else {
			g.drawImage(nothingImage, 10, 20, 130, 110, null);
		}
		
	}
	
	public void setColor(Color newColor) {
		currentPreviewColor = newColor;
	}
	
	public void refresh() {
		this.repaint();
	}
}
